
**************************************************************************************************************************************************
******************* Code for 'Doing Less with Less: Capital Misallocation, investment and the prodcutivty slowdown in Australia *******************
***************************************************** Code for markups stiamtion******************************************************************

**************************************************DATE: AUG 2022 ******************************************************************************
**************************************************** AUTHOR: Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************

*** Code strcuture
*00. Preliminaries and globals
*01. Intiail varaible constrcution and tirmminh
*02. Industry level first stage estimation
*03. Industry level second stage estimation
*04 Final constrcution


**00. Preliminaries and globals for markups


*** Define  defaltors and measures
local ind industry // level of prod fucn est

local go_defl go_ipd_02 // gross output

local int_defl int_ipd_02 // int inputs

local va_defl va_ipd_02 // direct VA

local k_defl K_defl // capital stock

local inv_defl GFCF_defl // inv deflator

local wage_meas labour // measure of labour income

local output income // output measure - income 

local input variable2 // input measure

local labour fte // measure of employment

** Current Current (0) or lagged book value of K stock, or perp inv est (2)
local k_meas = 1 // preffered metric is lagged, capturing K stock going into period

** Single or double deflation of VA (with BIT measure must single)
local s_or_d_defl s // deflate va directly, or based on int inputs and gross output sepereately


* Define the instrument sets
local k_instr k
local k_instr_tl k k2 l1k1_instr m1k1_instr

**** Trim extreme growth? no (0), if large share of industry change (1), if in outlier in distry (2), based multiprod rules
local trim = 0
local cuts 1 // remove those employing less than this



***********************************************01. Intiail varaible constrcution
** Load in data 
use "$data\full_prod_bit.dta", clear 

xtset firmid fyear
** smaller industry metrics
g ind_02 = floor(industry/100)
g ind_03 = floor(industry/10)

* based on above deflate and make K measures
g def_y = `go_defl'

g def_yva = `va_defl'

g def_in =`int_defl'

if `k_meas' == 0 {
g K_nom = k_bit
g def_k = k_defl
g K = K_nom/def_k
}

if `k_meas' == 1 {
g K_nom = l.k_bit
g def_k = l.k_defl
g K = K_nom/def_k
}

* Nominal
g wagebill = `wage_meas'

g Y_nom = `output'
g Yva_nom = (`output'-`input')

g M_nom = `input'

* real
g Y = Y_nom/def_y
g y = log(Y)
g M = M_nom/def_in

if "`s_or_d_defl'" == "s" {
	g YVA = Yva_nom/def_yva
}

if "`s_or_d_defl'" == "d" {
	g YVA = Y-M
}
** logged	
g yva = log(YVA)
g k = log(K)

g L = `labour'
g l = log(L)

g m = log(M) 


g W_nom = wagebill/L
g W = W_nom/def_y
g w = log(W)



*---------------creating variables fr prod fund est--------------------------------------------------------*
* higher order terms on inputs for translog

g l_lag=l.l
g l2 =l^2
g l2_lag = l.l2

g l_2lag = l2.l

g l1m1 = l*m
g l1m1_lag = l.l1m1 

g k_lag = l.k
g k2= k^2
g k2_lag = l.k2

g l1k1 = l*k
g l1k1_lag = l.l1k1
g l1k1_instr = l_lag*k


g m_lag= l.m
g m2 = m^2
g m2_lag = m2^2

g m1k1 = m*k
g m1k1_lag = l.m1k1
g m1k1_instr = l.m*k

g w_lag = l.w

******* Labour productivity measures ***************
g l_prod_fte = Y/fte
g l_prod_hcnt = Y/hcnt
g l_prod_fte_adj = Y/fte_adj


**** Make a simple Lerner index
g lerner = (Y_nom-variable1)/Y_nom
g lerner_depr = (Y_nom-variable1-deprexps)/Y_nom
g profit = (Y_nom-totlexps)/Y_nom


************* 02 Trimmming depending on choices
*********** Make a few industry totals for trimming or use in GO estiamtion
if `trim' == 1 {
** Total sales
bysort fyear: egen Q=sum(Y)
g q=log(Q)
** Ind sales
bysort `ind' fyear: egen QS=sum(Y)
g qs = log(QS)

* National K
bysort fyear: egen Q_K=sum(K)

** Ind K
bysort `ind' fyear: egen QS_K=sum(K)


xtset firmid fyear


******* Do some data cleaning - dropping if change is really large sahre of total level

drop if d.Y> 0.25*l.QS & d.Y!=.

drop if -d.Y> 0.25*l.QS & d.Y!=.

drop if d.K> 0.25*l.QS_K & d.K!=.

drop if -d.K> 0.25*l.QS_K & d.K!=.

}

if `trim' == 2 {

***** Trimming based extreme growth - not great for small firms
g d_y = d.y
g d_yva = d.yva
g d_k = d.k
g d_l = d.l
g d_m = d.m

g k_rat = k/l
g d_k_rat = d.k/l

egen d_y_1=pctile(d_y),p(1)
egen d_y_99=pctile(d_y),p(99)

egen d_yva_1=pctile(d_yva),p(1)
egen d_yva_99=pctile(d_yva),p(99)

egen d_k_1=pctile(d_k),p(1)
egen d_k_99=pctile(d_k),p(99)

egen d_l_1=pctile(d_l),p(1)
egen d_l_99=pctile(d_l),p(99)

egen d_m_1=pctile(d_m),p(1)
egen d_m_99=pctile(d_m),p(99)

egen d_k_rat_1=pctile(d_k_rat),p(1)
egen d_k_rat_99=pctile(d_k_rat),p(99)




by firmid: g remove =  sum(d_y<d_y_1 & d_y !=.)
drop if remove >0 & remove !=.
drop remove

by firmid: g remove =  sum(d_y>d_y_99 & d_y !=.)
drop if remove >0 & remove !=.
drop remove

by firmid: g remove =  sum(d_yva<d_yva_1 & d_yva !=.)
drop if remove >0 & remove !=.
drop remove

by firmid: g remove =  sum(d_yva>d_yva_99 & d_yva !=.)
drop if remove >0 & remove !=.
drop remove

by firmid: g remove =  sum(d_l<d_l_1 & d_l !=.)
drop if remove >0 & remove !=.
drop remove

by firmid: g remove =  sum(d_l>d_l_99 & d_l !=.)
drop if remove >0 & remove !=.
drop remove

by firmid: g remove =  sum(d_k<d_k_1 & d_k !=.)
drop if remove >0 & remove !=.
drop remove

by firmid: g remove =  sum(d_k>d_k_99 & d_k !=.)
drop if remove >0 & remove !=.
drop remove

by firmid: g remove =  sum(d_m<d_m_1 & d_m !=.)
drop if remove >0 & remove !=.
drop remove

by firmid: g remove =  sum(d_m>d_m_99 & d_m !=.)
drop if remove >0 & remove !=.
drop remove

}



*** Triming based on if ever seen massive jump
if `trim' == 3 {

by firmid : g remove = sum(f.Y_nom>50*Y_nom & f2.Y_nom<f.Y_nom/50)
drop if remove >0 & remove !=.
drop remove

by firmid : g remove = sum(f.K_nom>50*K_nom & f2.K_nom<f.K_nom/50)
drop if remove >0 & remove !=.
drop remove


by firmid : g remove = sum(f.wagebill>30*wagebill & f2.wagebill<f.wagebill/30)
drop if remove >0 & remove !=.
drop remove

by firmid : g remove = sum(f.L>10*L & f2.L<f.L/10 & L >20)
drop if remove >0 & remove !=.
drop remove

}

** remove really small employment
drop if L<`cuts'

***********************02. Industry level first stage estimation
****** Loop over industries

levelsof `ind' , local(ind_names)

foreach i in   `ind_names' {

preserve 

drop if `ind' != `i'

*---COMPUTE UNCORRECTED FIRM LABOUR and M SHARES------*
g alpha_l_no_adj=wagebill/(Y_nom)
g alpha_m_no_adj=M_nom/(Y_nom)


***** Construct  elast variable based on median of yearly industry w avg a la Sylverson - not prefered metric
**** Broad version not dropping firms who won't be in the sample
*Annual labour sahres
egen `ind'_wages = sum(wagebill), by(fyear)
egen `ind'_Y_nom = sum(Y_nom), by(fyear)
g `ind'_wages_share =  `ind'_wages/`ind'_Y_nom

*Number of observations per year to use invrse to make all years even
egen nobs_share = total(`ind'_wages_share!=.), by(fyear)
replace nobs_share = 1/nobs_share

** Set coefficient on labour to be median year
summarize `ind'_wages_share [w = nobs_share], detail
g `ind'_l1_syl_br = r(p50)

drop nobs_share

*Annual material sahres
egen `ind'_M = sum(M_nom), by(fyear)

g `ind'_M_share =  `ind'_M/`ind'_Y_nom

*Number of observations per year to use invrse to make all years even
egen nobs_share = total(`ind'_M_share!=.), by(fyear)
replace nobs_share = 1/nobs_share

** Set coefficient on labour to be median year
summarize `ind'_M_share [w = nobs_share], detail
g `ind'_m1_syl_br = r(p50)

drop `ind'_*_share `ind'_wages `ind'_M `ind'_Y_nom nobs_share

***** Now do for those that will be in the other samples
*These firms won't make it into the sample, and negative VA can 
drop if y == .
drop if l == .
drop if k == .
drop if m == .

count if y>0

local count_no = `r(N)'

if `count_no'>0 {

**** Narrower version with those in the sample be in the sample - Syversion metric
*Annual labour sahres
egen `ind'_wages = sum(wagebill), by(fyear)
egen `ind'_Yva_nom = sum(Yva_nom), by(fyear)
g `ind'_wages_share =  `ind'_wages/`ind'_Yva_nom

*Number of observations per year to use invrse to make all years even
egen nobs_share = total(`ind'_wages_share!=.), by(fyear)
replace nobs_share = 1/nobs_share

** Set coefficient on labour to be median year
summarize `ind'_wages_share [w = nobs_share], detail
g `ind'_l1_syl_nar = r(p50)

drop nobs_share

*Annual M sahres
egen `ind'_M = sum(M_nom), by(fyear)
egen `ind'_Y_nom = sum(Y_nom), by(fyear)
g `ind'_M_share =  `ind'_M/`ind'_Y_nom

*Number of observations per year to use invrse to make all years even
egen nobs_share = total(`ind'_M_share!=.), by(fyear)
replace nobs_share = 1/nobs_share

** Set coefficient on labour to be median year
summarize `ind'_M_share [w = nobs_share], detail
g `ind'_m1_syl_nar = r(p50)

drop `ind'_*_share `ind'_wages `ind'_M `ind'_Y_nom nobs_share


**********Skip if too few obs already
egen nobs1 = total(y!=. & l!=. & k!=. & m!=.)

*** If too few groups or observations, drop indsutry

if nobs1>300 {


xtset firmid fyear



******* First stage regressions for different specs ***********************

**************************** DLW No price control regression

** Ado file that makes intereactions with order x polinominal
Poly l k m, poly(5)

reg y $interactionvars 
predict phi_DLW // first stage fitted prod term
g phi_DLW_lag = l.phi_DLW
predict epsilon, res // first stage residual

** Can turn on to do entry exit adjustment. Not ued as minimal effect evident
/*
** Run a probit on the same variable to get proability exit for adjusting
local no_hat 0
capture probit exit  $interactionvars 
if _rc != 0 {
}
else {
local no_hat 1
predict Pr_hat_DLW if e(sample), pr
}
*/
drop var_*
macro drop interactionvars

*---COMPUTE CORRECTED SHARES adjusting for error------*
gen y_c= y-epsilon
gen Y_c=exp(y_c)
gen alpha_l=wagebill/(Y_c*def_y)
gen alpha_m=M_nom/(Y_c*def_y)

drop y_c Y_c epsilon


******************************** DLW price  controlling for correlated price to identify GO prodcutin function per Gandhi et al

Poly l k m w, poly(5)

reg y $interactionvars 
predict phi_DLW_w
g phi_DLW_w_lag = l.phi_DLW_w
predict epsilon, res
/*
** Run a probit o nthe same variable to get proability exit for adjusting
local no_hat_w 0
capture probit exit  $interactionvars 
if _rc != 0 {
}
else {
local no_hat_w 1
predict Pr_hat_DLW_w if e(sample), pr
}
*/
drop var_*
macro drop interactionvars

*---COMPUTE CORRECTED SHARES----*
gen y_c= y-epsilon
gen Y_c=exp(y_c)
gen alpha_l_w=wagebill/(Y_c*def_y)
gen alpha_m_w=M_nom/(Y_c*def_y)

drop y_c Y_c epsilon




***---- Now with fyear controls, as seems common in literature 
**************************** DLW No price control regression

Poly l k m, poly(5)

reg y $interactionvars i.fyear 
predict phi_DLW_y
g phi_DLW_y_lag = l.phi_DLW_y
predict epsilon, res

/*
** Run a probit on the same variable to get proability exit for adjusting
local no_hat 0
capture probit exit  $interactionvars 
if _rc != 0 {
}
else {
local no_hat 1
predict Pr_hat_DLW if e(sample), pr
}
*/
drop var_*
macro drop interactionvars

*---COMPUTE CORRECTED SHARES------*
gen y_c= y-epsilon
gen Y_c=exp(y_c)
gen alpha_l_y=wagebill/(Y_c*def_y)
gen alpha_m_y=M_nom/(Y_c*def_y)

drop y_c Y_c epsilon


******************************** DLW price control regression with year
Poly l k m w, poly(5)

reg y $interactionvars i.fyear
predict phi_DLW_w_y
g phi_DLW_w_y_lag = l.phi_DLW_w_y
predict epsilon, res
/*
** Run a probit o nthe same variable to get proability exit for adjusting
local no_hat_w 0
capture probit exit  $interactionvars 
if _rc != 0 {
}
else {
local no_hat_w 1
predict Pr_hat_DLW_w if e(sample), pr
}
*/
drop var_*
macro drop interactionvars

*---COMPUTE CORRECTED SHARES----*
gen y_c= y-epsilon
gen Y_c=exp(y_c)
gen alpha_l_w_y=wagebill/(Y_c*def_y)
gen alpha_m_w_y=M_nom/(Y_c*def_y)

drop y_c Y_c epsilon


**********************************03. Industry level second stage estimation

************************* Prepare for mata program by removing firms that can't be used
g const = 1
drop if y == .
drop if l_lag==.
drop if m_lag == .
drop if k==.
drop if phi_DLW==.
drop if phi_DLW_lag==.
drop if phi_DLW_w==.
drop if phi_DLW_w_lag==.

drop if phi_DLW_y==.
drop if phi_DLW_y_lag==.
drop if phi_DLW_w_y==.
drop if phi_DLW_w_y_lag==.



*** If too few groups or observations, drop indsutry to avoid small samples
xtreg y l k m
g nobs = e(N)
g ng = e(N_g)


if ng>100 & nobs>300 {


******** Get strarting parameters for GMM via *****

**CD prod func
reg y l k m
g blols=_b[l]
g bkols=_b[k]
g bmols=_b[m]


* Store the estimates as strating values
matrix temp = e(b)
local tempsize = colsof(temp)

macro drop _b_ols 

local b_ols = el("temp",1,`tempsize')

forvalues x = 2/`tempsize'  {
	local b_ols_temp = el("temp",1,`x'-1)
	local b_ols  `b_ols' `b_ols_temp'
	macro drop _b_ols_temp
}
	
matrix drop temp
macro drop tempsize 

** Translog prod func

reg y l k m l2 k2 m2 l1k1 l1m1 m1k1 
g blols_tl=_b[l]
g bkols_tl=_b[k]
g bmols_tl=_b[m]
g bl2ols_tl=_b[l2]
g bk2ols_tl=_b[k2]
g bm2ols_tl=_b[m2]
g blkols_tl=_b[l1k1]
g blmols_tl=_b[l1m1]
g bmkols_tl=_b[m1k1]


* Store the estimates as strating values
matrix temp = e(b)
local tempsize = colsof(temp)

macro drop _b_olstl 

local b_olstl = el("temp",1,`tempsize')

forvalues x = 2/`tempsize'  {
	local b_ols_temp = el("temp",1,`x'-1)
	local b_olstl  `b_olstl' `b_ols_temp'
	macro drop _b_ols_temp
}
	
matrix drop temp
macro drop tempsize 

** Translog no cross terms

reg y l k m l2 k2 m2  
g blols_tll=_b[l]
g bkols_tll=_b[k]
g bmols_tll=_b[m]
g bl2ols_tll=_b[l2]
g bk2ols_tll=_b[k2]
g bm2ols_tll=_b[m2]


* Store the estimates as strating values
matrix temp = e(b)
local tempsize = colsof(temp)

macro drop _b_olstll 

local b_olstll = el("temp",1,`tempsize')

forvalues x = 2/`tempsize'  {
	local b_ols_temp = el("temp",1,`x'-1)
	local b_olstll  `b_olstll' `b_ols_temp'
	macro drop _b_ols_temp
}
	
matrix drop temp
macro drop tempsize 


************* Estimate using some of the other built in methods - not prefered
******* Levpet estimates *****
/*
** CD
* Estimate
prodest y, free(l) proxy(m) state(k) id(firmid) t(fyear)  fsres(fres_y) 

*Get Coeffs
gen bl_lev = _b[l]
gen bk_lev = _b[k]
gen bm_lev = _b[m]

predict prod_lev, residual 

*Make markup and prod
gen y_lev= y-fres_y
gen Y_lev=exp(y_lev)
gen alpha_l_lev = wagebill/(Y_lev*def_y)
gen alpha_m_lev = M_nom/(Y_lev*def_y)


g markup_lev = bl_lev/alpha_l_lev 
g markup_lev_no_adj = bl_lev/alpha_l_no_adj

g markup_lev_m = bm_lev/alpha_m_lev 
g markup_lev_m_no_adj = bm_lev/alpha_m_no_adj

** CD Yva ACF
* Estimate
prodest y, free(l) proxy(m) state(k) id(firmid) t(fyear)  fsres(fres_y_acf) acf

*Get Coeffs

gen bl_lev_acf = _b[l]
gen bk_lev_acf = _b[k]
gen bm_lev_acf = _b[m]


predict prod_lev_acf, residual 

*Make markup and prod
gen y_lev_acf= y-fres_y_acf
gen Y_lev_acf=exp(y_lev_acf)

gen alpha_l_lev_acf = wagebill/(Y_lev_acf*def_y)
gen alpha_m_lev_acf = M_nom/(Y_lev_acf*def_y)

gen markup_lev_acf = bl_lev_acf/alpha_l_lev_acf 
gen markup_lev_acf_no_adj = bl_lev_acf/alpha_l_no_adj 

gen markup_lev_m_acf = bm_lev_acf/alpha_m_lev_acf 
gen markup_lev_m_acf_no_adj = bm_lev_acf/alpha_m_no_adj 

** Translog ACF
* Estimate
prodest y, free(l) proxy(m) state(k) id(firmid) t(fyear) fsres(fres_y_acf_trans) acf trans

*Get Coeffs


gen bl1_lev_acf_trans = _b[l]
gen bk1_lev_acf_trans = _b[k]
gen bm1_lev_acf_trans = _b[m]
gen bl2_lev_acf_trans = _b[var_11]
gen bk2_lev_acf_trans = _b[var_22]
gen bm2_lev_acf_trans = _b[var_33]
gen bl1k1_lev_acf_trans = _b[var_12]
gen bl1m1_lev_acf_trans = _b[var_13]
gen bm1k1_lev_acf_trans = _b[var_23]

gen betal_lev_acf_trans = bl1_lev_acf_trans+2*bl2_lev_acf_trans*l+bl1k1_lev_acf_trans*k+bl1m1_lev_acf_trans*m
gen betam_lev_acf_trans = bm1_lev_acf_trans+2*bm2_lev_acf_trans*l+bm1k1_lev_acf_trans*k+bl1m1_lev_acf_trans*l


predict prod_lev_acf_trans, residual 

*Make markup and prod

gen y_lev_acf_trans= y-fres_y_acf_trans
gen Y_lev_acf_trans=exp(y_lev_acf_trans)
gen alpha_l_lev_acf_trans = wagebill/(Y_lev_acf_trans*def_y)
gen alpha_m_lev_acf_trans = M_nom/(Y_lev_acf_trans*def_y)

gen markup_lev_acf_trans = betal_lev_acf_trans/alpha_l_lev_acf_trans 
gen markup_lev_acf_trans_no_adj = betal_lev_acf_trans/alpha_l_no_adj

gen markup_lev_m_acf_trans = betam_lev_acf_trans/alpha_m_lev_acf_trans 
gen markup_lev_m_acf_trans_no_adj = betam_lev_acf_trans/alpha_m_no_adj


** Two-eqn woolridge
prodest y, free(l) proxy(m) state(k) id(firmid) t(fyear)   method(wrdg)

*Get Coeffs

gen bl_lev_wool = _b[l]
gen bk_lev_wool = _b[k]
gen bm_lev_wool = _b[m]

predict prod_lev_wool, residual 

*Make markup and prod

gen markup_lev_wool = bl_lev_wool/alpha_l 
gen markup_lev_wool_no_adj = bl_lev_wool/alpha_l_no_adj 

gen markup_lev_m_wool = bm_lev_wool/alpha_m 
gen markup_lev_m_wool_no_adj = bm_lev_wool/alpha_m_no_adj 


** One-eqn woolridge - no dynamics
Poly k m, poly(3)


mata: mata mlib index
ivreg2 yva k $interactionvars  (l m = l_lag m_lag), gmm2s cluster(firmid)

*Get Coeffs
gen bl_lev_va_wool_1 = _b[l]
gen bk_lev_va_wool_1 = _b[k]

predict lev_va_wool_1_res, residual 

g prod_lev_va_wool_1 = yva - lev_va_wool_1_res -bl_lev_va_wool_1*l -bk_lev_va_wool_1*k

drop $interactionvars

*Make markup and prod

gen yva_lev_wool_1= yva-lev_va_wool_1_res
gen Yva_lev_wool_1=exp(yva_lev_wool_1)
gen alpha_l_va_wool_1 = wagebill/(Yva_lev_wool_1*def_yva)

gen markup_lev_va_wool_1 = bl_lev_va_wool_1/alpha_l_va_wool_1 
gen markup_lev_va_wool_1_no_adj = bl_lev_va_wool_1/alpha_l_va_no_adj 



***** One-eqn woolridge - no dynamics - LAG
Poly k_lag m_lag, poly(3)


mata: mata mlib index
ivreg2 yva k $interactionvars  (l=l_lag), gmm2s cluster(firmid)

*Get Coeffs
gen bl_lev_va_wool_l1 = _b[l]
gen bk_lev_va_wool_l1 = _b[k]

predict lev_va_wool_l1_res, residual 

g prod_lev_va_wool_l1 = yva - lev_va_wool_l1_res -bl_lev_va_wool_l1*l -bk_lev_va_wool_l1*k

drop $interactionvars

*Make markup and prod

gen yva_lev_wool_l1= yva-lev_va_wool_l1_res
gen Yva_lev_wool_l1=exp(yva_lev_wool_l1)
gen alpha_l_va_wool_l1 = wagebill/(Yva_lev_wool_l1*def_yva)

gen markup_lev_va_wool_l1 = bl_lev_va_wool_l1/alpha_l_va_wool_l1 
gen markup_lev_va_wool_l1_no_adj = bl_lev_va_wool_l1/alpha_l_va_no_adj 



** One-eqn woolridge -  dynamics
Poly k_lag m_lag l_lag, poly(3)

ivreg2 yva k $interactionvars  (l=l_2lag), gmm2s cluster(firmid)

*Get Coeffs
gen bl_lev_va_wool_dyn = _b[l]
gen bk_lev_va_wool_dyn = _b[k]

predict lev_va_wool_dyn_res, residual 

g prod_lev_va_wool_dyn = yva - lev_va_wool_dyn_res-bl_lev_va_wool_dyn*l -bk_lev_va_wool_dyn*k

*Make markup and prod

gen yva_lev_wool_dyn= yva-lev_va_wool_dyn_res
gen Yva_lev_wool_dyn=exp(yva_lev_wool_dyn)
gen alpha_l_va_wool_dyn = wagebill/(Yva_lev_wool_dyn*def_yva)


gen markup_lev_va_wool_dyn = bl_lev_va_wool_dyn/alpha_l_va_wool_dyn 
gen markup_lev_va_wool_dyn_no_adj = bl_lev_va_wool_dyn/alpha_l_va_no_adj 

drop $interactionvars

*/

********** Estimate Second stage of the DLW procedure using own code
**** CD
*DLW no price control

capture matrix drop B
** GMM estimation
DLW  y, phi(phi_DLW) phi_lag(phi_DLW_lag) endo_var(const l k m) endo_var_lag(const l_lag k_lag m_lag) instr(const l_lag m_lag `k_instr') start(`b_ols')


g l1_dlw = beta_dlw[1,2]
g k1_dlw = beta_dlw[1,3]
g m1_dlw = beta_dlw[1,4]

g markup_DLW = l1_dlw /alpha_l
g markup_DLW_no_adj = l1_dlw /alpha_l_no_adj

g markup_DLW_m = m1_dlw /alpha_m
g markup_DLW_m_no_adj = m1_dlw /alpha_m_no_adj

g prod_DLW = phi_DLW-l1_dlw *l-k1_dlw *k-m1_dlw*m

*DLW with price control

capture matrix drop B

DLW  y, phi(phi_DLW_w) phi_lag(phi_DLW_w_lag) endo_var(const l k m) endo_var_lag(const l_lag k_lag m_lag) instr(const l_lag m_lag `k_instr' w_lag) start(`b_ols')

g l1_dlw_w = beta_dlw[1,2]
g k1_dlw_w = beta_dlw[1,3]
g m1_dlw_w = beta_dlw[1,4]

g markup_DLW_w = l1_dlw_w /alpha_l_w
g markup_DLW_w_no_adj = l1_dlw_w /alpha_l_no_adj

g markup_DLW_m_w = m1_dlw_w /alpha_m_w
g markup_DLW_m_w_no_adj = m1_dlw_w /alpha_m_no_adj

g prod_DLW_w = phi_DLW_w-l1_dlw_w*l-k1_dlw_w*k-m1_dlw_w*m


*** Now with year

*DLW no price control

capture matrix drop B

DLW  y, phi(phi_DLW_y) phi_lag(phi_DLW_y_lag) endo_var(const l k m) endo_var_lag(const l_lag k_lag m_lag) instr(const l_lag m_lag `k_instr') start(`b_ols')


g l1_dlw_y = beta_dlw[1,2]
g k1_dlw_y = beta_dlw[1,3]
g m1_dlw_y = beta_dlw[1,4]

g markup_DLW_y = l1_dlw_y /alpha_l_y
g markup_DLW_y_no_adj = l1_dlw_y /alpha_l_no_adj

g markup_DLW_y_m = m1_dlw_y /alpha_m_y
g markup_DLW_y_m_no_adj = m1_dlw_y /alpha_m_no_adj

g prod_DLW_y = phi_DLW_y-l1_dlw_y *l-k1_dlw_y *k-m1_dlw_y*m

*DLW with price control

capture matrix drop B

DLW  y, phi(phi_DLW_w_y) phi_lag(phi_DLW_w_y_lag) endo_var(const l k m) endo_var_lag(const l_lag k_lag m_lag) instr(const l_lag m_lag `k_instr' w_lag) start(`b_ols')

g l1_dlw_w_y = beta_dlw[1,2]
g k1_dlw_w_y = beta_dlw[1,3]
g m1_dlw_w_y = beta_dlw[1,4]

g markup_DLW_w_y = l1_dlw_w_y /alpha_l_w_y
g markup_DLW_w_y_no_adj = l1_dlw_w_y /alpha_l_no_adj

g markup_DLW_m_w_y = m1_dlw_w_y /alpha_m_w_y
g markup_DLW_m_w_y_no_adj = m1_dlw_w_y /alpha_m_no_adj

g prod_DLW_w_y = phi_DLW_w_y-l1_dlw_w_y*l-k1_dlw_w_y*k-m1_dlw_w_y*m


**** Trans
*DLW no price control


capture matrix drop B

DLW  y, phi(phi_DLW) phi_lag(phi_DLW_lag) endo_var(const l k m l2 k2 m2 l1k1 l1m1 m1k1) endo_var_lag(const l_lag k_lag m_lag l2_lag k2_lag m2_lag l1k1_lag l1m1_lag m1k1_lag) instr(const l_lag m_lag l2_lag m2_lag l1m1_lag `k_instr_tl') start(`b_olstl')


g l1_dlw_tl = beta_dlw[1,2]
g k1_dlw_tl = beta_dlw[1,3]
g m1_dlw_tl = beta_dlw[1,4]
g l2_dlw_tl = beta_dlw[1,5]
g k2_dlw_tl = beta_dlw[1,6]
g m2_dlw_tl = beta_dlw[1,7]
g l1k1_dlw_tl = beta_dlw[1,8]
g l1m1_dlw_tl = beta_dlw[1,9]
g m1k1_dlw_tl = beta_dlw[1,10]

g l_tl_dlw = l1_dlw_tl+2*l2_dlw_tl*l+l1k1_dlw_tl*k+l1m1_dlw_tl*m
g m_tl_dlw = m1_dlw_tl+2*m2_dlw_tl*m+l1m1_dlw_tl*l+m1k1_dlw_tl*k

g markup_DLW_tl = l_tl_dlw /alpha_l
g markup_DLW_tl_no_adj = l_tl_dlw /alpha_l_no_adj

g markup_DLW_tl_m = m_tl_dlw /alpha_m
g markup_DLW_tl_m_no_adj = m_tl_dlw /alpha_m_no_adj

g prod_DLW_tl = phi_DLW-l1_dlw_tl *l-k1_dlw_tl *k-m1_dlw_tl*m-l2_dlw_tl*l^2-k2_dlw_tl*k^2-m2_dlw_tl*m^2-l1k1_dlw_tl*l*k-l1m1_dlw_tl*l*m-m1k1_dlw_tl*m*k


** Price control

capture matrix drop B

DLW  y, phi(phi_DLW_w) phi_lag(phi_DLW_w_lag) endo_var(const l k m l2 k2 m2 l1k1 l1m1 m1k1) endo_var_lag(const l_lag k_lag m_lag l2_lag k2_lag m2_lag l1k1_lag l1m1_lag m1k1_lag) instr(const l_lag m_lag l2_lag m2_lag l1m1_lag `k_instr_tl' w_lag) start(`b_olstl')


g l1_dlw_tl_w = beta_dlw[1,2]
g k1_dlw_tl_w = beta_dlw[1,3]
g m1_dlw_tl_w = beta_dlw[1,4]
g l2_dlw_tl_w = beta_dlw[1,5]
g k2_dlw_tl_w = beta_dlw[1,6]
g m2_dlw_tl_w = beta_dlw[1,7]
g l1k1_dlw_tl_w = beta_dlw[1,8]
g l1m1_dlw_tl_w = beta_dlw[1,9]
g m1k1_dlw_tl_w = beta_dlw[1,10]

g l_tl_dlw_w = l1_dlw_tl_w+2*l2_dlw_tl_w*l+l1k1_dlw_tl_w*k+l1m1_dlw_tl_w*m
g m_tl_dlw_w = m1_dlw_tl_w+2*m2_dlw_tl_w*m+l1m1_dlw_tl_w*l+m1k1_dlw_tl_w*k

g markup_DLW_tl_w = l_tl_dlw_w /alpha_l_w
g markup_DLW_tl_w_no_adj = l_tl_dlw_w /alpha_l_no_adj

g markup_DLW_tl_m_w = m_tl_dlw_w /alpha_m_w
g markup_DLW_tl_m_w_no_adj = m_tl_dlw_w /alpha_m_no_adj

g prod_DLW_tl_w = phi_DLW_w-l1_dlw_tl_w *l-k1_dlw_tl_w *k-m1_dlw_tl_w*m-l2_dlw_tl_w*l^2-k2_dlw_tl_w*k^2-m2_dlw_tl_w*m^2-l1k1_dlw_tl_w*l*k-l1m1_dlw_tl_w*l*m-m1k1_dlw_tl_w*m*k


** Year controls

*DLW no price control

capture matrix drop B

DLW  y, phi(phi_DLW_y) phi_lag(phi_DLW_y_lag) endo_var(const l k m l2 k2 m2 l1k1 l1m1 m1k1) endo_var_lag(const l_lag k_lag m_lag l2_lag k2_lag m2_lag l1k1_lag l1m1_lag m1k1_lag) instr(const l_lag m_lag l2_lag m2_lag l1m1_lag `k_instr_tl') start(`b_olstl')


g l1_dlw_tl_y = beta_dlw[1,2]
g k1_dlw_tl_y = beta_dlw[1,3]
g m1_dlw_tl_y = beta_dlw[1,4]
g l2_dlw_tl_y = beta_dlw[1,5]
g k2_dlw_tl_y = beta_dlw[1,6]
g m2_dlw_tl_y = beta_dlw[1,7]
g l1k1_dlw_tl_y = beta_dlw[1,8]
g l1m1_dlw_tl_y = beta_dlw[1,9]
g m1k1_dlw_tl_y = beta_dlw[1,10]

g l_tl_dlw_y = l1_dlw_tl_y+2*l2_dlw_tl_y*l+l1k1_dlw_tl_y*k+l1m1_dlw_tl_y*m
g m_tl_dlw_y = m1_dlw_tl_y+2*m2_dlw_tl_y*m+l1m1_dlw_tl_y*l+m1k1_dlw_tl_y*k

g markup_DLW_tl_y = l_tl_dlw_y /alpha_l_y
g markup_DLW_tl_y_no_adj = l_tl_dlw_y /alpha_l_no_adj

g markup_DLW_tl_m_y = m_tl_dlw_y /alpha_m_y
g markup_DLW_tl_m_y_no_adj = m_tl_dlw_y /alpha_m_no_adj

g prod_DLW_tl_y = phi_DLW_y-l1_dlw_tl_y *l-k1_dlw_tl_y *k-m1_dlw_tl_y*m-l2_dlw_tl_y*l^2-k2_dlw_tl_y*k^2-m2_dlw_tl_y*m^2-l1k1_dlw_tl_y*l*k-l1m1_dlw_tl_y*l*m-m1k1_dlw_tl_y*m*k


** Price control

capture matrix drop B

DLW  y, phi(phi_DLW_w_y) phi_lag(phi_DLW_w_y_lag) endo_var(const l k m l2 k2 m2 l1k1 l1m1 m1k1) endo_var_lag(const l_lag k_lag m_lag l2_lag k2_lag m2_lag l1k1_lag l1m1_lag m1k1_lag) instr(const l_lag m_lag l2_lag m2_lag l1m1_lag `k_instr_tl' w_lag) start(`b_olstl')


g l1_dlw_tl_w_y = beta_dlw[1,2]
g k1_dlw_tl_w_y = beta_dlw[1,3]
g m1_dlw_tl_w_y = beta_dlw[1,4]
g l2_dlw_tl_w_y = beta_dlw[1,5]
g k2_dlw_tl_w_y = beta_dlw[1,6]
g m2_dlw_tl_w_y = beta_dlw[1,7]
g l1k1_dlw_tl_w_y = beta_dlw[1,8]
g l1m1_dlw_tl_w_y = beta_dlw[1,9]
g m1k1_dlw_tl_w_y = beta_dlw[1,10]

g l_tl_dlw_w_y = l1_dlw_tl_w_y+2*l2_dlw_tl_w_y*l+l1k1_dlw_tl_w_y*k+l1m1_dlw_tl_w_y*m
g m_tl_dlw_w_y = m1_dlw_tl_w_y+2*m2_dlw_tl_w_y*m+l1m1_dlw_tl_w_y*l+m1k1_dlw_tl_w_y*k

g markup_DLW_tl_w_y = l_tl_dlw_w_y /alpha_l_w_y
g markup_DLW_tl_w_y_no_adj = l_tl_dlw_w_y /alpha_l_no_adj

g markup_DLW_tl_m_w_y = m_tl_dlw_w_y /alpha_m_w_y
g markup_DLW_tl_m_w_y_no_adj = m_tl_dlw_w_y /alpha_m_no_adj

g prod_DLW_tl_w_y = phi_DLW_w_y-l1_dlw_tl_w_y *l-k1_dlw_tl_w_y *k-m1_dlw_tl_w_y*m-l2_dlw_tl_w_y*l^2-k2_dlw_tl_w_y*k^2-m2_dlw_tl_w_y*m^2-l1k1_dlw_tl_w_y*l*k-l1m1_dlw_tl_w_y*l*m-m1k1_dlw_tl_w_y*m*k


************** Translog no cross terms


*DLW no price control

capture matrix drop B

DLW  y, phi(phi_DLW) phi_lag(phi_DLW_lag) endo_var(const l k m l2 k2 m2) endo_var_lag(const l_lag k_lag m_lag l2_lag k2_lag m2_lag) instr(const l_lag m_lag l2_lag m2_lag k k2) start(`b_olstll')


g l1_dlw_tll = beta_dlw[1,2]
g k1_dlw_tll = beta_dlw[1,3]
g m1_dlw_tll = beta_dlw[1,4]
g l2_dlw_tll = beta_dlw[1,5]
g k2_dlw_tll = beta_dlw[1,6]
g m2_dlw_tll = beta_dlw[1,7]

g l_tll_dlw = l1_dlw_tll+2*l2_dlw_tll*l
g m_tll_dlw = m1_dlw_tll+2*m2_dlw_tll*m

g markup_DLW_tll = l_tll_dlw /alpha_l
g markup_DLW_tll_no_adj = l_tll_dlw /alpha_l_no_adj

g markup_DLW_tll_m = m_tll_dlw /alpha_m
g markup_DLW_tll_m_no_adj = m_tll_dlw /alpha_m_no_adj

g prod_DLW_tll = phi_DLW-l1_dlw_tll *l-k1_dlw_tll *k-m1_dlw_tll*m-l2_dlw_tll*l^2-k2_dlw_tll*k^2-m2_dlw_tll*m^2


** Price control

capture matrix drop B

DLW  y, phi(phi_DLW_w) phi_lag(phi_DLW_w_lag) endo_var(const l k m l2 k2 m2 ) endo_var_lag(const l_lag k_lag m_lag l2_lag k2_lag m2_lag ) instr(const l_lag m_lag l2_lag m2_lag l1m1_lag k k2 w_lag) start(`b_olstll')


g l1_dlw_tll_w = beta_dlw[1,2]
g k1_dlw_tll_w = beta_dlw[1,3]
g m1_dlw_tll_w = beta_dlw[1,4]
g l2_dlw_tll_w = beta_dlw[1,5]
g k2_dlw_tll_w = beta_dlw[1,6]
g m2_dlw_tll_w = beta_dlw[1,7]


g l_tll_dlw_w = l1_dlw_tll_w+2*l2_dlw_tll_w*l
g m_tll_dlw_w = m1_dlw_tll_w+2*m2_dlw_tll_w*m

g markup_DLW_tll_w = l_tll_dlw_w /alpha_l_w
g markup_DLW_tll_w_no_adj = l_tll_dlw_w /alpha_l_no_adj

g markup_DLW_tll_m_w = m_tll_dlw_w /alpha_m_w
g markup_DLW_tll_m_w_no_adj = m_tll_dlw_w /alpha_m_no_adj

g prod_DLW_tll_w = phi_DLW_w-l1_dlw_tll_w *l-k1_dlw_tll_w *k-m1_dlw_tll_w*m-l2_dlw_tll_w*l^2-k2_dlw_tll_w*k^2-m2_dlw_tll_w*m^2


** Year controls

*DLW no price control

capture matrix drop B

DLW  y, phi(phi_DLW_y) phi_lag(phi_DLW_y_lag) endo_var(const l k m l2 k2 m2 ) endo_var_lag(const l_lag k_lag m_lag l2_lag k2_lag m2_lag ) instr(const l_lag m_lag l2_lag m2_lag k k2) start(`b_olstll')


g l1_dlw_tll_y = beta_dlw[1,2]
g k1_dlw_tll_y = beta_dlw[1,3]
g m1_dlw_tll_y = beta_dlw[1,4]
g l2_dlw_tll_y = beta_dlw[1,5]
g k2_dlw_tll_y = beta_dlw[1,6]
g m2_dlw_tll_y = beta_dlw[1,7]


g l_tll_dlw_y = l1_dlw_tll_y+2*l2_dlw_tll_y*l
g m_tll_dlw_y = m1_dlw_tll_y+2*m2_dlw_tll_y*m

g markup_DLW_tll_y = l_tll_dlw_y /alpha_l_y
g markup_DLW_tll_y_no_adj = l_tll_dlw_y /alpha_l_no_adj

g markup_DLW_tll_m_y = m_tll_dlw_y /alpha_m_y
g markup_DLW_tll_m_y_no_adj = m_tll_dlw_y /alpha_m_no_adj

g prod_DLW_tll_y = phi_DLW_y-l1_dlw_tll_y *l-k1_dlw_tll_y *k-m1_dlw_tll_y*m-l2_dlw_tll_y*l^2-k2_dlw_tll_y*k^2-m2_dlw_tll_y*m^2


** Price control

capture matrix drop B

DLW  y, phi(phi_DLW_w_y) phi_lag(phi_DLW_w_y_lag) endo_var(const l k m l2 k2 m2 ) endo_var_lag(const l_lag k_lag m_lag l2_lag k2_lag m2_lag ) instr(const l_lag m_lag l2_lag m2_lag k k2 w_lag) start(`b_olstll')


g l1_dlw_tll_w_y = beta_dlw[1,2]
g k1_dlw_tll_w_y = beta_dlw[1,3]
g m1_dlw_tll_w_y = beta_dlw[1,4]
g l2_dlw_tll_w_y = beta_dlw[1,5]
g k2_dlw_tll_w_y = beta_dlw[1,6]
g m2_dlw_tll_w_y = beta_dlw[1,7]


g l_tll_dlw_w_y = l1_dlw_tll_w_y+2*l2_dlw_tll_w_y*l
g m_tll_dlw_w_y = m1_dlw_tll_w_y+2*m2_dlw_tll_w_y*m

g markup_DLW_tll_w_y = l_tll_dlw_w_y /alpha_l_w_y
g markup_DLW_tll_w_y_no_adj = l_tll_dlw_w_y /alpha_l_no_adj

g markup_DLW_tll_m_w_y = m_tll_dlw_w_y /alpha_m_w_y
g markup_DLW_tll_m_w_y_no_adj = m_tll_dlw_w_y /alpha_m_no_adj

g prod_DLW_tll_w_y = phi_DLW_w_y-l1_dlw_tll_w_y *l-k1_dlw_tll_w_y *k-m1_dlw_tll_w_y*m-l2_dlw_tll_w_y*l^2-k2_dlw_tll_w_y*k^2-m2_dlw_tll_w_y*m^2

***
save "$outputsind\prod_k_`k_meas'_instr_`k_instr'_out_`output'_int_`input'_trm_`trim'_`ind'_`file'_l`cuts'_`i'.dta"  , replace

}
}
}
restore



}


levelsof `ind' , local(ind_names)

clear

*******************************04 Final constrcution

** Bring individual files together
foreach i in  `ind_names' {


	capture append using "`outputs'\Ind_files\prod_k_`k_meas'_instr_`k_instr'_out_`output'_int_`input'_trm_`trim'_`ind'_`file'_l`cuts'_`i'.dta" 
	capture erase "`outputs'\Ind_files\prod_k_`k_meas'_instr_`k_instr'_out_`output'_int_`input'_trm_`trim'_`ind'_`file'_l`cuts'_`i'.dta"
}

**** Syverson prodcutivity just over firms with abilitiy to estimate productivtiy

*Annual labour sahres
egen `ind'_wages = sum(wagebill), by(fyear `ind')
egen `ind'_Y_nom = sum(Y_nom), by(fyear `ind')
g `ind'_wages_share =  `ind'_wages/`ind'_Y_nom

*Number of observations per year to use invrse to make all years even
egen nobs_share = total(`ind'_wages_share!=.), by(fyear industry)
replace nobs_share = 1/nobs_share

** Set coefficient on labour to be median year

levelsof industry , local(ind_names)

g `ind'_l1_syl_s = .

foreach i in   `ind_names' {

summarize `ind'_wages_share [w = nobs_share] if `ind' == `i', detail
replace `ind'_l1_syl_s = r(p50) if `ind' == `i'

}

drop nobs_share


*Annual M sahres
egen `ind'_M = sum(M_nom), by(fyear `ind')

g `ind'_M_share =  `ind'_M/`ind'_Y_nom

*Number of observations per year to use invrse to make all years even
egen nobs_share = total(`ind'_M_share!=.), by(fyear industry)
replace nobs_share = 1/nobs_share

** Set coefficient on labour to be median year

levelsof industry , local(ind_names)

g `ind'_m1_syl_s = .

foreach i in   `ind_names' {

summarize `ind'_M_share [w = nobs_share] if `ind' == `i', detail
replace `ind'_m1_syl_s = r(p50) if `ind' == `i'

}

drop `ind'_*_share `ind'_wages `ind'_M `ind'_Y_nom nobs_share

*Labour syverson
g markup_syl_l_no_adj_s = `ind'_l1_syl_s/alpha_l_no_adj
g markup_syl_l_s = `ind'_l1_syl_s/alpha_l
g markup_syl_l_s_w = `ind'_l1_syl_s/alpha_l_w
g markup_syl_l_s_w_y = `ind'_l1_syl_s/alpha_l_w_y

g markup_syl_l_br_no_adj = `ind'_l1_syl_br/alpha_l_no_adj
g markup_syl_l_br = `ind'_l1_syl_br/alpha_l
g markup_syl_l_br_w = `ind'_l1_syl_br/alpha_l_w
g markup_syl_l_br_w_y = `ind'_l1_syl_br/alpha_l_w_y

g markup_syl_l_nar_no_adj = `ind'_l1_syl_nar/alpha_l_no_adj
g markup_syl_l_nar = `ind'_l1_syl_nar/alpha_l
g markup_syl_l_nar_w = `ind'_l1_syl_nar/alpha_l_w
g markup_syl_l_nar_w_y = `ind'_l1_syl_nar/alpha_l_w_y

*****M syverson
g markup_syl_m_no_adj_s = `ind'_m1_syl_s/alpha_m_no_adj
g markup_syl_m_s = `ind'_m1_syl_s/alpha_m
g markup_syl_m_s_w = `ind'_m1_syl_s/alpha_m_w
g markup_syl_m_s_w_y = `ind'_m1_syl_s/alpha_m_w_y

g markup_syl_m_br_no_adj = `ind'_m1_syl_br/alpha_m_no_adj
g markup_syl_m_br = `ind'_m1_syl_br/alpha_m
g markup_syl_m_br_w = `ind'_m1_syl_br/alpha_m_w
g markup_syl_m_br_w_y = `ind'_m1_syl_br/alpha_m_w_y

g markup_syl_m_nar_no_adj = `ind'_m1_syl_nar/alpha_m_no_adj
g markup_syl_m_nar = `ind'_m1_syl_nar/alpha_m
g markup_syl_m_nar_w = `ind'_m1_syl_nar/alpha_m_w
g markup_syl_m_nar_w_y = `ind'_m1_syl_nar/alpha_m_w_y


save "$outputs\mark_k_`k_meas'_instr_`k_instr'_out_`output'_int_`input'_trm_`trim'_`ind'_`file'_l`cuts'.dta" , replace








